/*
 * EtCaptureDeviceHandler.h 
 *
 * This class handels capture from video source 
 *
 * The usage of this file and the EyeTwig framework is under the Eytwig license. 
 *
 * for more information please log to http://www.eyetwig.com
 * or contact support@eyetwig.com
 *
 * Copyright (c) 2000-2009 EyeTwig Inc. All rights reserved.
 *
 */

#import <Cocoa/Cocoa.h>
#import <QTKit/QTKit.h>

@class EtImage;
@class VideoDeviceCapture;

//all listners should implement this interface
@interface NSObject (EtCaptureDeviceHandler)
- (void) onFrameReady:(EtImage*)frame;
@end


@interface EtCaptureDeviceHandler : NSObject {
	
	VideoDeviceCapture* mCaptureDeviceHandler;
	id mDelegate;
	EtImage* mImage;
}

//public
+ (NSDictionary*) getDeviceNamesToDeviceMap;
+ (QTCaptureDevice*) getDefaultCaptureDevice;

-(BOOL) setCaptureDevice:(QTCaptureDevice*)device withCaptureSize:(NSSize)captureSize andDelegate:(id)indelegate;
-(BOOL) setDefaultCaptureDevice:(NSSize)captureSize andDelegate:(id)indelegate;
-(void) startVideoCapture;
-(void) stopVideoCapture;




@end
